<?php


namespace Youlogix\Idebit\Model;

use Magento\Sales\Api\Data\TransactionInterface;


class Idebit extends \Magento\Payment\Model\Method\AbstractMethod {

    const PAYMENT_COIN2PAY_CODE = 'idebit';
    const ACC_BIZ = 'idebitbiz';
    const ACC_MONEY = 'idebitmoney';

    protected $_code = self::PAYMENT_COIN2PAY_CODE;

    /**
     *
     * @var \Magento\Framework\UrlInterface 
     */
    protected $_storeManager;
    protected $_urlBuilder;
    protected $_supportedCurrencyCodes = array(
        'SRD'
    );
    
    private $checkoutSession;
    private $_additionalInfo;
    protected $_logger;

    /**
     * 
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Api\ExtensionAttributesFactory $extensionFactory
     * @param \Magento\Framework\Api\AttributeValueFactory $customAttributeFactory
     * @param \Magento\Payment\Helper\Data $paymentData
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Payment\Model\Method\Logger $logger
     * @param \Magento\Framework\UrlInterface $urlBuilder
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb $resourceCollection
     * @param array $data
     */
      public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Api\ExtensionAttributesFactory $extensionFactory,
        \Magento\Framework\Api\AttributeValueFactory $customAttributeFactory,
        \Magento\Payment\Helper\Data $paymentData,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Payment\Model\Method\Logger $logger,
        \Youlogix\Idebit\Helper\Idebit $helper,
        \Magento\Sales\Model\Order\Email\Sender\OrderSender $orderSender,
        \Magento\Framework\HTTP\ZendClientFactory $httpClientFactory,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Payment\Model\Info $additionalInfo,
        \Magento\Store\Model\StoreManagerInterface $storeManager
              
    ) {
        $this->_logger = $logger;
        $this->_storeManager = $storeManager;
        $this->helper = $helper;
        $this->orderSender = $orderSender;
        $this->httpClientFactory = $httpClientFactory;
        $this->checkoutSession = $checkoutSession;
        $this->_additionalInfo = $additionalInfo;

        parent::__construct(
            $context,
            $registry,
            $extensionFactory,
            $customAttributeFactory,
            $paymentData,
            $scopeConfig,
            $logger
        );

    }

    public function canUseForCurrency($currencyCode) {
        if (!in_array($currencyCode, $this->_supportedCurrencyCodes)) {
            return false;
        }
        return true;
    }

    public function getRedirectUrl() {
        return $this->_storeManager->getStore()->getBaseUrl().'idebit/standard/redirect/';
    }

    public function getReturnUrl() {
        return $this->_storeManager->getStore()->getBaseUrl().'idebit/standard/response/';
    }

    public function getCancelUrl() {
        return $this->_storeManager->getStore()->getBaseUrl().'idebit/standard/cancel/';
    }

    /**
     * Return url according to environment
     * @return string
     */
    public function getCgiUrl() {
        $env = $this->getConfigData('environment');
        if ($env === 'production') {
            return $this->getConfigData('production_url');
        }
        return $this->getConfigData('sandbox_url');
    }

    public function buildCheckoutRequest(){
        $order = $this->checkoutSession->getLastRealOrder();
        
        $orderId = $this->checkoutSession->getLastRealOrderId();
        $total = round($order->getBaseGrandTotal(), 2);
        
        $accessToken = $this->getAuthTokenFromApi($orderId, $total);

        if(!$accessToken){
            return false;
        }
        
        
        $billing_address = $order->getBillingAddress();
        $coinCurrency = $this->checkoutSession->getCoinCurrency();
        $params = array();
        $params["Checkout"] = true;
        $params["hasaddress"] = 1;
        $params["CustomerReferenceNr"] = $this->checkoutSession->getLastRealOrderId();
        $params["inputCurrency"] = $order->getOrderCurrencyCode();;
        $params["Amount"] = round($order->getBaseGrandTotal(), 2);
        $params["billingfirstname"] = $billing_address->getFirstName();
        $params["billinglastname"] = $billing_address->getLastname();
        $params["billingorg"] = $billing_address->getCompany();
        $params["billingphone"] = $billing_address->getTelephone();
        $params["billingemail"] = $order->getCustomerEmail();
        $streetAddress = $billing_address->getStreet();
        $params["billingaddress"] = $streetAddress[0];
        $params["billingpostalcode"] = $billing_address->getPostcode();
        $params["billingcity"] = $billing_address->getCity();
        $params["billingprovince"] = $billing_address->getRegion();
        $params["billingcountryid"] = $billing_address->getCountryId();
        $params["txnid"] = substr(hash('sha256', mt_rand() . microtime()), 0, 20);
        $params["curl"] = $this->getCancelUrl();
        $params["furl"] = $this->getReturnUrl();
        $params["surl"] = $this->getReturnUrl();
        $params["hash"] = $this->generateIdebitHash($params['txnid'],$params['Amount'], $params['CustomerReferenceNr'], $params['billingfirstname'],$params['billingemail']);
        $params["orderID"] = $this->checkoutSession->getLastRealOrderId();
        $params["total"] = round($order->getBaseGrandTotal(), 2);
        $params["tax"] = round($order->getShippingTaxAmount(), 2);
        $params["TokenID"] = $accessToken;
        $params["Email"] = $order->getCustomerEmail();
        $params["Inv"] = $this->checkoutSession->getLastRealOrderId();
        $params["returnURL"] = $this->getReturnUrl();
        
        
        $api_url = $this->getConfigData('redirect_url');
        $api_url = rtrim($api_url, '/');
        $redirectUrl = $api_url.'/PaymentController.php?TokenID='.$accessToken.'&Email='.$order->getCustomerEmail().'&Amount='.round($order->getBaseGrandTotal(), 2).'&Desc='.$this->checkoutSession->getLastRealOrderId().'&Inv='.$this->checkoutSession->getLastRealOrderId().'&returnURL='.$this->getReturnUrl();
        return $redirectUrl;
        //return $params;
    }

    public function getAuthTokenFromApi($invoicenumber, $amount){
        $api_url = $this->getConfigData('redirect_url');
        $merchant_id = $this->getConfigData('merchant_id');
        $merchantPass = $this->getConfigData('merchant_pass');
        $api_url = rtrim($api_url, '/');
        //$c_url = 'https://testhop.hakrinbank.com/gateway/service/WebshopAuth/00005407/5d2aFa7c62/48/50';
        $c_url = $api_url.'/WebshopAuth/'.$merchant_id.'/'.$merchantPass.'/'.$invoicenumber.'/'.$amount;
        $curl = curl_init($c_url);
        curl_setopt($curl, CURLOPT_HEADER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("Content-type: application/json"));
        curl_setopt($curl, CURLOPT_POST, true);
        //curl_setopt($curl, CURLOPT_POSTFIELDS);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLINFO_HEADER_OUT, true);
        $result = curl_exec($curl);
        $response = json_decode($result); 
        if($response){
            if($response->Code==0){
                return $response->Resp;
            }else{
                if($response->Code==1){
                    $api_msg = 'Service Offline';
                }else if($response->Code==2){
                    $api_msg = 'Account Violation (IP Black-Listed)';
                }else if($response->Code==3){
                    $api_msg = 'Input Not Allowed (Dirty/SQL)';
                }else if($response->Code==4){
                    $api_msg = 'Account Inactive';
                }else if($response->Code==5){
                    $api_msg = 'Password Incorrect';
                }else{
                    $api_msg = 'Empty response Msg from Api';
                }
                $this->messageManager->addExceptionMessage($e, __('We can\'t place the order. Please use another Payment method or contact to administrator. If you are administrator please check system log.'));
                $this->_logger->debug($api_msg); 
                $returnUrl = $this->getCheckoutHelper()->getUrl('checkout');
                $this->getResponse()->setRedirect($returnUrl);
            }
        }else{
            $this->messageManager->addExceptionMessage($e, __('We can\'t place the order. Please use another Payment method. if you are administrator please check system log.'));
            $this->_logger->debug('Empty Response from Api. Please ensure that you are using correct credential.. (redirect url/Merchant Id / Merchant Pass)'); 
            $returnUrl = $this->getCheckoutHelper()->getUrl('checkout');
            $this->getResponse()->setRedirect($returnUrl);
        }
        return false;
    }




    public function generateIdebitHash($txnid, $amount, $productInfo, $name, $email){
        $posted = array(
            'txnid' => $txnid,
            'amount' => $amount,
            'productinfo' => $productInfo,
            'firstname' => $name,
            'email' => $email,
        );
        $hashSequence = 'api|txnid|amount|productinfo|firstname|email';
        $hashVarsSeq = explode('|', $hashSequence);
        $hash_string = '';
        foreach ($hashVarsSeq as $hash_var) {
            $hash_string .= isset($posted[$hash_var]) ? $posted[$hash_var] : '';
            $hash_string .= '|';
        }
        return strtolower(hash('sha512', $hash_string));
    }

    //validate response
    public function validateResponse($returnParams) {
        /*if ($returnParams['status'] == 'pending' || $returnParams['status'] == 'failed' || $returnParams['status'] == 'cancel') {
            return false;
        }*/
       /* if ($returnParams['SecurityCode'] != $this->getConfigData("security_code")){
            return false;
        }*/
        return true;
    }
    //validate response
    public function checkCoinAddressedUsed($returnParams) {
        if (array_key_exists('paid', $returnParams) && ($returnParams['paid'] == 'approved' || $returnParams['paid'] == 'APPROVED')) {
            return true;
        }
        return false;
    }

    public function postProcessing(
        \Magento\Sales\Model\Order $order,
        \Magento\Framework\DataObject $payment, $response) {
            $payment->setTransactionId($order->getIncrementId());
            $payment->setTransactionAdditionalInfo('idebit_mihpayid',$response['paid']);
            $payment->setAdditionalInformation('idebit_order_status', 'approved');
            $payment->addTransaction(TransactionInterface::TYPE_ORDER);
            $payment->setIsTransactionClosed(0);
            $payment->place();
            $order->setStatus('processing');
            $order->save();
        }
    public function assignData(\Magento\Framework\DataObject $data)
    {
        $additionalData = $data->getAdditionalData();
        $coinCurrency = $additionalData['coin_currency'];
        $info = $this->getInfoInstance();
        $info->addData(
            [
                'coin_currency' => $coinCurrency
            ]
        );
        $this->getInfoInstance()->setPoNumber($coinCurrency);
        $this->getInfoInstance()->setAdditionalData('Coin Currency:: '.$coinCurrency);
        $this->checkoutSession->setCoinCurrency($coinCurrency);
        return $this;
    }
}
