<?php

namespace Youlogix\Idebit\Controller\Standard;

class Response extends \Youlogix\Idebit\Controller\IdebitAbstract {

    public function execute() {
        $returnUrl = $this->getCheckoutHelper()->getUrl('checkout');
        $params = $this->getRequest()->getParams();
        try {
            $paymentMethod = $this->getPaymentMethod();
            if ($paymentMethod->validateResponse($params) && $paymentMethod->checkCoinAddressedUsed($params)) {
                $returnUrl = $this->getCheckoutHelper()->getUrl('checkout/onepage/success');
                $order = $this->getOrder();
                $payment = $order->getPayment();
                $paymentMethod->postProcessing($order, $payment, $params);
            } else {
                $this->messageManager->addErrorMessage(__('Payment failed. Please try again or choose a different payment method'));
                $returnUrl = $this->getCheckoutHelper()->getUrl('checkout/onepage/failure');
            }
        } catch (\Magento\Framework\Exception\LocalizedException $e) {
            $this->messageManager->addExceptionMessage($e, $e->getMessage());
        } catch (\Exception $e) {
            $this->messageManager->addExceptionMessage($e, __('We can\'t place the order.'));
        }
        $this->getResponse()->setRedirect($returnUrl);
    }

}
