<?php

namespace Youlogix\Idebit\Controller\Standard;

class Redirect extends \Youlogix\Idebit\Controller\IdebitAbstract {

    public function execute() {
        if (!$this->getRequest()->isAjax()) {
            $this->_cancelPayment();
            $this->_checkoutSession->restoreQuote();
            $this->getResponse()->setRedirect(
                    $this->getCheckoutHelper()->getUrl('checkout')
            );
        }
        $quote = $this->getQuote();
        $email = $this->getRequest()->getParam('email');
        if ($this->getCustomerSession()->isLoggedIn()) {
            $this->getCheckoutSession()->loadCustomerQuote();
            $quote->updateCustomerData($this->getQuote()->getCustomer());
        } else {
            $quote->setCustomerEmail($email);
        }
        if ($this->getCustomerSession()->isLoggedIn()) {
            $quote->setCheckoutMethod(\Magento\Checkout\Model\Type\Onepage::METHOD_CUSTOMER);
        } else {
            $quote->setCheckoutMethod(\Magento\Checkout\Model\Type\Onepage::METHOD_GUEST);
        }
        $quote->setCustomerEmail($email);
        $quote->save();
        if($buildCheckOutRequest = $this->getPaymentMethod()->buildCheckoutRequest()){
            //$array = array('data'=>json_encode($buildCheckOutRequest));
            //$params = [];
            $params["fields"] = array();
            //https://testhop.hakrinbank.com/gateway/service/
            $params["url"] = $buildCheckOutRequest;//$this->getPaymentMethod()->getCgiUrl();
            return $this->resultJsonFactory->create()->setData($params);
        }
        return false;
    }

}
