<?php
/**************************************************************
 * 
 * @Company Name: YouLogix Infotech Pvt Ltd.
 * @Author: Youlogix Team
 * @Date: 05 June 2017
 * @Description: Used for process idebit payment
 * @Support : http://youlogix.com/
 *  
 *************************************************************/
 
class YouLogix_Idebit_IndexController extends Mage_Core_Controller_Front_Action
{
    public function indexAction()
    {		
		$this->loadLayout();     
		$this->renderLayout();
    }
    
    public function errorAction()
    {		
		$this->loadLayout();     
		$this->renderLayout();

    }

    public function redirectAction()
    {
		$session = Mage::getSingleton('checkout/session');
		$session->setIdebitQuoteId($session->getQuoteId());
		$quoteId = $session->getIdebitQuoteId();
		$quote = Mage::getModel( 'sales/quote' )->load($quoteId);
        if($quote->getId()){
            $quote->setIsActive(true)->save();
            $session->setQuoteId($quoteId);
        }
        $this->getResponse()->setBody($this->getLayout()->createBlock('idebit/standard_redirect')->toHtml());
    }

    public function responseAction(){
        $params = Mage::app()->getRequest()->getParams();
        $api_url = Mage::helper('idebit')->getConfig('gateway_url');
        $api_url = rtrim($api_url, '/');
        $merchant_id = Mage::helper('idebit')->getConfig('merchant_id');
        $merchantPass = Mage::helper('idebit')->getConfig('merchant_pass');
        $session = Mage::getSingleton('checkout/session');
        $orderIncrementId = $session->getIdebitOrderId();

        $order = Mage::getModel('sales/order')->loadByIncrementId($orderIncrementId);
        $orderTotal = (int)$order->getBaseGrandTotal();

        //Date
        $orderDate = $order->getCreatedAt();
        $date = $orderDate;
        $splittedDate = explode(" ", $date);                
        $splitDate = explode("-", $splittedDate[0]);
        $finalDate = $splitDate[2] . $splitDate[1] . substr($splitDate[0], 2);
        $validateUrl = $api_url . "/PaymentStatus/" . $merchant_id . "/" . $merchantPass . "/" . $orderIncrementId . "/" . $finalDate;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $validateUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        $validateMessage = "";
        
        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            $validateMessage = 'Error:' . curl_error($ch);
        } else {
            $validateMessage = $result;
        }
        curl_close ($ch);
        $hopresonse = json_decode($result, true);
        $hopbedrag = $hopresonse['Amount'];
        if($orderTotal == $hopbedrag){
            //Komt overeen ga naar paid pagina
            //$returnUrl = $this->getCheckoutHelper()->getUrl('checkout/onepage/success');    
            $this->orderSuccess();

        } else {
            //Komt niet overeen ga naar failed pagina
            $this->orderFailed();
            Mage::getSingleton("core/session")->addError(__('Payed amount does not match order total. Please contact shop for further information'));
            $checkout_link = Mage::helper('checkout/url')->getCheckoutUrl();
            Mage::app()->getFrontController()->getResponse()->setRedirect($checkout_link);
        }
       
	}
	public function cancelAction(){
		$session = Mage::getSingleton('checkout/session');
		$quoteId = $session->getIdebitQuoteId();
		$quote = Mage::getModel( 'sales/quote' )->load($quoteId);
		$order = Mage::getModel('sales/order');
		if($session->getIdebitOrderId()){
			$this->orderFailed();
		}
        if($quote->getId()){
        	Mage::getSingleton("core/session")->addError(__('Payment failed. Please try again or choose a different payment method'));
            $checkout_link = Mage::helper('checkout/url')->getCheckoutUrl();
            Mage::app()->getFrontController()->getResponse()->setRedirect($checkout_link);
        }
        else{
        	$url = Mage::getBaseUrl();
			Mage::app()->getFrontController()->getResponse()->setRedirect($url);
        }
	}

    public function orderFailed(){
        $session = Mage::getSingleton('checkout/session');
        $quoteId = $session->getIdebitQuoteId();
        $quote = Mage::getModel( 'sales/quote' )->load($quoteId);
        $order = Mage::getModel('sales/order');
        if($session->getIdebitOrderId()){
            $order->loadByIncrementId($session->getIdebitOrderId());
            $order->cancel();
            $order->save();
        }
        $session->unsIdebitOrderId();
        $session->unsIdebitQuoteId();
    }
    public function orderSuccess(){
        $session = Mage::getSingleton('checkout/session');
        $order = Mage::getModel('sales/order');
        $order->loadByIncrementId($session->getIdebitOrderId()); 
        $order->sendNewOrderEmail();
        $order->setState(Mage_Sales_Model_Order::STATE_PROCESSING)->setStatus(Mage_Sales_Model_Order::STATE_PROCESSING)->save();
        $session->unsIdebitOrderId();
        $session->unsIdebitQuoteId();
        Mage::getSingleton('checkout/session')->getQuote()->setIsActive(false)->save();
        $this->_redirect('checkout/onepage/success', array('_secure'=>true));
    }
}
