<?php
/**************************************************************
 * 
 * @Company Name: YouLogix Infotech Pvt Ltd.
 * @Author: Youlogix Team
 * @Date: 05 June 2017
 * @Description: Used for process idebit payment
 * @Support : http://youlogix.com/
 *  
 *************************************************************/


class YouLogix_Idebit_Model_Standard extends Mage_Payment_Model_Method_Abstract
{
	
   protected $_code = 'idebit';
 
		
	/**
	* Return Order place redirect url
	*
	* @return string
	*/

    public function getOrderPlaceRedirectUrl(){
        return Mage::getUrl('idebit/index/redirect', array('_secure' => true));
    }

			
	
	 /**
     * Return form field array
     *
     * @return array
     */
	

	function getPostData(){
		$orderIncrementId = $this->getCheckout()->getLastRealOrderId();
		$session = Mage::getSingleton('checkout/session');
		$session->setIdebitOrderId($orderIncrementId);
		$order = Mage::getModel('sales/order')->loadByIncrementId($orderIncrementId);
		$totalAmount = (int)$order->getBaseGrandTotal();

		$api_url = Mage::helper('idebit')->getConfig('gateway_url'); //$idpay_settings['gateway_url'];
        $api_url = rtrim($api_url, '/');
        $merchant_id = Mage::helper('idebit')->getConfig('merchant_id'); //$idpay_settings['merchant_id'];
        $merchantPass = Mage::helper('idebit')->getConfig('merchant_pass'); //$idpay_settings['merchant_pass'];

        $accessToken = $this->getAuthTokenFromApi();
        if(!$accessToken){
        	$accessToken = Mage::helper('idebit')->getConfig('response_key'); //$idpay_settings['response_key'];	
        }	
        
        return $redirectUrl = $api_url.'/PaymentController.php?TokenID='.$accessToken.'&Email='.$order->getBillingAddress()->getEmail().'&Amount='.round($totalAmount, 2).'&Desc='.$orderIncrementId.'&Inv='.$orderIncrementId.'&returnURL='.Mage::getUrl('idebit/index/response').'&cancelURL='.Mage::getUrl('idebit/index/cancel');
        
	}

	public function getAuthTokenFromApi(){
		$orderIncrementId = $this->getCheckout()->getLastRealOrderId();
		$order = Mage::getModel('sales/order')->loadByIncrementId($orderIncrementId);

		$api_url = Mage::helper('idebit')->getConfig('gateway_url'); //$idpay_settings['gateway_url'];
	    $merchant_id = Mage::helper('idebit')->getConfig('merchant_id'); //$idpay_settings['merchant_id'];
	    $merchantPass = Mage::helper('idebit')->getConfig('merchant_pass'); //$idpay_settings['merchant_pass'];
	    $api_url = rtrim($api_url, '/');
	    $totalAmount = (int)$order->getBaseGrandTotal();
	    $c_url = $api_url.'/WebshopAuth/'.$merchant_id.'/'.$merchantPass.'/'.$orderIncrementId.'/'.round($totalAmount, 2);
	    $curl = curl_init($c_url);
	    curl_setopt($curl, CURLOPT_HEADER, false);
	    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
	    curl_setopt($curl, CURLOPT_HTTPHEADER, array("Content-type: application/json"));
	    curl_setopt($curl, CURLOPT_POST, true);
	    //curl_setopt($curl, CURLOPT_POSTFIELDS);
	    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
	    curl_setopt($curl, CURLINFO_HEADER_OUT, true);
	    $result = curl_exec($curl);
	    $response = json_decode($result);
	    if($response){
	        if($response->Code==0){
	            return $response->Resp;
	        }else{
	            if($response->Code==1){
	                $api_msg = 'Service Offline';
	            }else if($response->Code==2){
	                $api_msg = 'Account Violation (IP Black-Listed)';
	            }else if($response->Code==3){
	                $api_msg = 'Input Not Allowed (Dirty/SQL)';
	            }else if($response->Code==4){
	                $api_msg = 'Account Inactive';
	            }else if($response->Code==5){
	                $api_msg = 'Password Incorrect';
	            }else{
	                $api_msg = 'Empty response Msg from Api';
	            }
	        }
	    }

	}
	public function getCheckout(){
		return Mage::getSingleton('checkout/session');
	}
		
		
		
		
			
}
